% Generated by roxygen2 (4.0.2): do not edit by hand
\name{npc}
\alias{npc}
\title{Create Net Promoter Categories from Likelihood to Recommend Scores}
\usage{
npc(x, breaks = list(0:6, 7:8, 9:10))
}
\arguments{
\item{x}{A vector of \emph{Recommend} scores}

\item{breaks}{A \code{list} of length three, giving the integer Likert scale points for \emph{Detractors}, \emph{Passives}, and \emph{Promoters}, respectively. The default is \code{list(0:6, 7:8, 9:10)}}
}
\value{
Net Promoter categories
}
\description{
This function produces Net Promoter Categories for \code{\link{numeric}} or \code{\link{integer}} \emph{Recommend} data
}
\examples{
# The command below will generate Net Promoter categories for each point
# on a standard 0:10 Likelihood to Recommend scale
npc(0:10)

 # Here's how scores and categories map out. Notice that scores which are
 # 'off the scale' drop out as missing/invalid
data.frame(score = -2:12, category = npc(-2:12))

# When you have lots of data, summaries are useful
rec <- sample(0:10, prob=c(0.02, 0.01, 0.01, 0.01, 0.01, 0.03, 0.03, 0.09,
    0.22, 0.22, 0.35), 1000, replace=TRUE)

# A Histrogram of the Likelihood to Recommend scores we just generated
hist(rec, breaks=-1:10)

# A look at the by nps category using summary
summary(npc(rec))

# As above
table(npc(rec))

# As a crosstabulation
table(rec, npc(rec))

nps(rec)
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}
\seealso{
\code{\link{nps}}
}

