#'Convenience Functions and Tests for Working With the Net Promoter Score (NPS)
#'
#' \tabular{ll}{
#' Package: \tab NPS\cr
#' Type: \tab Package\cr
#' Version: \tab 1.1\cr
#' Date: \tab 2014-12-03\cr
#' License: \tab GPL (>= 2)\cr
#' LazyLoad: \tab yes\cr
#' Encoding: \tab UTF-8\cr
#' }
#'
#'Small functions to make working with survey data in the context of a Net Promoter programme easier. Specifically, data transformation methods, some methods for examining the statistical properties of the NPS, such as its variance and standard errors, and some simple inferential testing procedures. Net Promoter and NPS are registered trademarks of Bain & Company, Satmetrix Systems and Fred Reichheld.
#'
#'
#' @name NPS-package
#' @aliases NPS
#' @docType package
#' @author Brendan Rocks \email{rocks.brendan@@gmail.com}
#' @keywords package
NULL

#' This is data to be included in my package
#'
#' An idealised test data set, for demonstrating some of the NPS functions
#'
#' @name testdata
#' @docType data
#' @author Brendan Rocks \email{rocks.brendan@@gmail.com}
#' @keywords data
NULL