% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnmf_methods.R
\name{predict.nnmf}
\alias{predict.nnmf}
\alias{print.nnmf}
\title{Methods for nnmf object returned by \code{nnmf}}
\usage{
\method{predict}{nnmf}(object, newdata, which = c("A", "W", "H"),
  method = object$options$method, loss = object$options$loss, ...)

\method{print}{nnmf}(x, ...)
}
\arguments{
\item{object}{An NNMF object returned by \code{\link{nnmf}}}

\item{newdata}{A new matrix of x. No required when \code{which == 'A'}}

\item{which}{Either 'A' (default), 'W' or 'H'}

\item{method}{Either 'scd' or 'lee'. Default to \code{object$options$method}}

\item{loss}{Either 'mse' or 'mkl'. Default to \code{object$options$loss}}

\item{...}{Further arguments passed to 'nnlm' or 'print'}

\item{x}{An NNMF object returned by \code{\link{nnmf}}}
}
\value{
'A' or a class of 'nnlm' for 'predict.nnmf' and no return for 'print'.
}
\description{
Methods for nnmf object returned by \code{nnmf}
}
\examples{

x <- matrix(runif(50*20), 50, 20)
r <- nnmf(x, 2)
r
newx <- matrix(runif(50*30), 50, 30)
pred <- predict(r, newx, 'H')

}
\seealso{
\code{\link{nnmf}}, \code{\link{nnlm}}
}

