% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadSim.R
\name{NMreadSim}
\alias{NMreadSim}
\title{Read simulation results based on NMsim's track of model runs}
\usage{
NMreadSim(x, check.time = FALSE, dir.sims, wait = FALSE, quiet = FALSE, as.fun)
}
\arguments{
\item{x}{Path to the simulation-specific rds file generated by
NMsim, typically called `NMsim_paths.rds`. Can also be a table
of simulation runs as stored in `rds` files by `NMsim`. The
latter should almost never be used.}

\item{check.time}{If found, check whether `fst` file modification
time is newer than `rds` file. The `fst` is generated based on
information in `rds`, but notice that some systems don't
preserve the file modification times. Becasue of that,
`check.time` is `FALSE` by default.}

\item{dir.sims}{By default, `NMreadSim` will use information about
the relative path from the results table file (`_paths.rds`)
to the Nonmem simulation results. If these paths have changed,
or for other reasons this doesn't work, you can use the
`dir.sims` argument to specify where to find the Nonmem
simulation results. If an `.fst` file was already generated
and is found next to the `_paths.rds`, the path to the Nonmem
simulation results is not used.}

\item{wait}{If simulations seem to not be done yet, wait for them
to finish? If not, an error will be thrown. If you choose to
wait, the risk is results never come. `NMreadSim` will be
waiting for an `lst` file. If Nonmem fails, it will normally
generate an `lst` file. But if `NMTRAN` fails (checks of
control stream prior to running Nonmem), the `lst` file is not
generated.  Default is not to wait.}

\item{quiet}{Turn off some messages about what is going on?
Default is to report the messages.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data set of class defined by as.fun
}
\description{
Read simulation results based on NMsim's track of model runs
}
