% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR-shiny.R
\name{NGLVieweR-shiny}
\alias{NGLVieweR-shiny}
\alias{NGLVieweROutput}
\alias{renderNGLVieweR}
\alias{NGLVieweR_proxy}
\title{Shiny bindings for NGLVieweR}
\usage{
NGLVieweROutput(outputId, width = "100\%", height = "400px")

renderNGLVieweR(expr, env = parent.frame(), quoted = FALSE)

NGLVieweR_proxy(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a NGLVieweR.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{id}{single-element character vector indicating the output ID of the
chart to modify (if invoked from a Shiny module, the namespace will be added
automatically)}

\item{session}{The Shiny session object to which the map belongs; usually
the default value will suffice.}
}
\value{
\code{NGLVieweR} object that can be placed in the UI.
}
\description{
Output and render functions for using NGLVieweR within Shiny
applications and interactive Rmd documents.
}
\examples{
if (interactive()) {
library(shiny)

ui <- fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      textInput("selection", "Selection", "1-20"),
      selectInput("type", "Type", c("ball+stick", "cartoon", "backbone")),
      selectInput("color", "Color", c("orange", "grey", "white")),
      actionButton("add", "Add"),
      actionButton("remove", "Remove")
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server <- function(input, output) {
  output$structure <- renderNGLVieweR({
    NGLVieweR("7CID") \%>\%
      addRepresentation("cartoon",
        param = list(name = "cartoon", color = "residueindex")
      ) \%>\%
      stageParameters(backgroundColor = input$backgroundColor) \%>\%
      setQuality("high") \%>\%
      setFocus(0) \%>\%
      setSpin(TRUE)
  })
  observeEvent(input$add, {
    NGLVieweR_proxy("structure") \%>\%
      addSelection(isolate(input$type),
        param =
          list(
            name = "sel1",
            sele = isolate(input$selection),
            color = isolate(input$color)
          )
      )
  })

  observeEvent(input$remove, {
    NGLVieweR_proxy("structure") \%>\%
      removeSelection("sel1")
  })
}
shinyApp(ui, server)
}
}
\seealso{
\code{\link[=NGLVieweR_example]{NGLVieweR_example()}}
}
