% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpMice.R
\name{PipeOpMice}
\alias{PipeOpMice}
\title{PipeOpMice}
\description{
Implements mice methods as mlr3 pipeline more about mice \code{\link{autotune_mice}}
}
\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.
}

\section{Parameters}{

The parameters include inherited from [`PipeOpImpute`], as well as: \cr
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"imput_mice"}.
\item \code{m} :: \code{integer(1)}\cr
Number of datasets produced by mice, default \code{5}.
\item \code{maxit} :: \code{integer(1)}\cr
Maximum number of iterations for mice, default \code{5}.
\item \code{set_corr} :: \code{double(1)}\cr
Correlation or fraction of features used when optimize=FALSE. When correlation=FALSE, it represents a fraction of case to use in imputation for each variable, default \code{0.5}.
\item \code{set_method} :: \code{character(1)}\cr
Method used if optimize=FALSE. If NULL default method is used (more in methods_random section), default \code{'pmm'}.
\item \code{low_corr} :: \code{double(1)}\cr
Double between 0-1. Lower boundary of correlation used in inner optimization (used only when optimize=TRUE), default \code{0}.
\item \code{up_corr} :: \code{double(1)}\cr
Double between 0-1. Upper boundary of correlation used in inner optimization (used only when optimize=TRUE). Both of these parameters work the same for a fraction of case if correlation=FALSE,default \code{1}.
\item \code{methods_random} :: \code{character(1)}\cr
set of methods to chose. Avalible methods {"pmm", "midastouch", "sample", "cart", "rf"} Default 'pmm'. If seted on NULL this methods are used predictive mean matching (numeric data) logreg, logistic regression imputation (binary data, factor with 2 levels) polyreg, polytomous regression imputation for unordered categorical data (factor > 2 levels) polr, proportional odds model for (ordered, > 2 levels).
\item \code{iter} :: \code{integer(1)}\cr
Number of iteration for random search, default \code{5}.
\item \code{random.seed} :: \code{integer(1)}\cr
Random seed, default \code{123}.
\item \code{optimize} :: \code{logical(1)}\cr
If set TRUE, function will optimize parameters of imputation automatically. If parameters will be tuned by other method, should be set to FALSE, default \code{FALSE}.
\item \code{correlation} :: \code{logical(1)}\cr
If set TRUE correlation is used, if set FALSE then fraction of case, default \code{TRUE}.
}
}

\examples{
\donttest{

# Using debug learner for example purpose

  graph <- PipeOpMice$new() \%>>\%  LearnerClassifDebug$new()
  graph_learner <- GraphLearner$new(graph)

  # Task with NA

  resample(tsk("pima"), graph_learner, rsmp("cv", folds = 3))
}

}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpImpute]{mlr3pipelines::PipeOpImpute}} -> \code{mice_imputation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpMice$new()}}
\item \href{#method-clone}{\code{PipeOpMice$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMice$new(
  id = "impute_mice_B",
  m = 5,
  maxit = 5,
  set_cor = 0.5,
  set_method = "pmm",
  low_corr = 0,
  up_corr = 1,
  methods_random = c("pmm"),
  iter = 5,
  random.seed = 123,
  optimize = FALSE,
  correlation = FALSE,
  out_file = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMice$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
