% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDMV.R
\name{RDMV}
\alias{RDMV}
\title{Calculates Relative Difference from Mean Value (RDMV)}
\usage{
RDMV(
  r,
  w = c(3, 3),
  method = "range",
  na.rm = FALSE,
  include_scale = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{DTM as a SpatRaster, RasterLayer, RasterStack, or RasterBrick}

\item{w}{A vector of length 2 specifying the dimensions of the rectangular window to use where the first number is the number of rows and the second number is the number of columns. Window size must be an odd number. Default is 3x3.}

\item{method}{standardization method. Either "range" (the default) or "sd".}

\item{na.rm}{A logical indicating whether or not to remove NA values before calculations}

\item{include_scale}{logical indicating whether to append window size to the layer names (default = FALSE)}

\item{filename}{character Output filename.}

\item{overwrite}{logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{list with named options for writing files as in writeRaster}
}
\value{
a SpatRaster or RasterLayer
}
\description{
Calculates Relative Difference from Mean Value (RDMV). RDMV = (focal_value - local_mean)/local_range or RDMV = (focal_value - local_mean)/local_sd.
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + 
ncol(volcano)*10, 6478700, 6478700 + nrow(volcano)*10), 
crs = "EPSG:27200")
rdmv<- RDMV(r, w=c(5,5), na.rm = TRUE, method="range")
plot(rdmv)
}
\references{
Lecours, V., Devillers, R., Simms, A.E., Lucieer, V.L., Brown, C.J., 2017. Towards a Framework for Terrain Attribute Selection in Environmental Studies. Environmental Modelling & Software 89, 19-30. https://doi.org/10.1016/j.envsoft.2016.11.027
}
