% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MomCums.r
\name{conv_Mom2Cum}
\alias{conv_Mom2Cum}
\title{Convert moments to cumulants (univariate)}
\usage{
conv_Mom2Cum(mu_x)
}
\arguments{
\item{mu_x}{the r-vector of moments starting from the first moment - the mean -
and arriving to the r-th order moment}
}
\value{
\code{cum_x} the vector of univariate cumulants
}
\description{
Obtains a vector of univariate cumulants from a vector of
univariate moments
}
\examples{
mu_x<- c(1,2,3,4)
conv_Mom2Cum(mu_x)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 3.4 formula 3.20
}
\seealso{
Other Moments and cumulants: 
\code{\link{conv_Cum2MomMulti}()},
\code{\link{conv_Cum2Mom}()},
\code{\link{conv_Mom2CumMulti}()}
}
\concept{Moments and cumulants}
