% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationSigma_Ye.R
\name{EstimationSigma_Ye}
\alias{EstimationSigma_Ye}
\title{Estimate numerically the Cholesky-factorization from the JLL-based models}
\usage{
EstimationSigma_Ye(SigmaUnres, res, M, G, Economies, DomUnit)
}
\arguments{
\item{SigmaUnres}{unrestricted variance-covariance matrix (K x K)}

\item{res}{residuals from the VAR of the JLL model (K x T)}

\item{M}{number of domestic unspanned factors per country (scalar)}

\item{G}{number of global unspanned factors (scalar)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{DomUnit}{Name of the economy which is assigned as the dominant unit. \cr
If no dominant unit is assigned, then this variable is defined as "none"}
}
\value{
Cholesky-factorization after the maximization (K x K)
}
\description{
Estimate numerically the Cholesky-factorization from the JLL-based models
}
\keyword{internal}
