% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.summary.R
\name{load.summary}
\alias{load.summary}
\title{Loading multiple summary statistics from genome-wide association studies}
\usage{
load.summary(files, cor.pheno = NULL, indep.snps = NULL, est.var = FALSE,
  columnNames = c("snp", "a1", "a2", "freq", "beta", "se", "n"),
  fixedN = NULL)
}
\arguments{
\item{files}{A vector of file names as strings. Each file name should contain summary statistics of
one trait to be included in the multi-trait analysis. The columns of the summary statistics have to
contain (uppercase or lowercase does not matter) \code{'snp'} (marker ID), \code{'a1'} (the first allele),
\code{'a2'} (the second allele), \code{'freq'},
(frequency of the first allele), \code{'beta'} (effect size), \code{'se'} (standard error), and 
\code{'n'} (sample size).}

\item{cor.pheno}{A #traits x #traits matrix of correlation matrix of the phenotypes, to be used to 
construct the multi-trait test statistic. If \code{NULL},
this matrix will be estimated from genome-wide summary statistics. If you have partially overlapping 
samples for different traits, shrinkage correlation matrix is recommended (see reference), so in that
case, unless you know what you are doing, leave this argument as default, i.e. \code{NULL}.}

\item{indep.snps}{A vector of strings containing the names of a set of independent SNPs. This is 
recommended to be generated by LD-pruning the genotype data in a certain cohort. Typically the 
number of SNPs should be more than 10,000 in order to obtain a good estimate of \code{cor.pheno}. If
\code{cor.pheno = NULL}, this argument cannot be \code{NULL}.}

\item{est.var}{A logical value. If \code{FALSE}, each phenotypic variance is assumed to be known as 1. 
If \code{TRUE}, each phenotypic variance will be estimated to adjust the summary statistics, so that
the corresponding phenoypic variance is 1.}

\item{columnNames}{A vector with names of columns containing necessary information in the input file;
default values are c('snp','a1','a2','freq','beta','se','n'). The values are case-insensitive. Note: check
your allele definitions for different traits are based on the same strand!}

\item{fixedN}{sample size to assume across all analyses, when provided, this number will be used
(instead of the ones specified in the input files)}
}
\value{
The function returns a list of class \code{multi.summary}, containing two elements: \code{gwa}
(the cleaned data to be processed in multi-trait GWAS), \code{cor.pheno} (user input or estimated), and 
\code{var.pheno} (default or estimated).
}
\description{
The function loads multiple meta-GWAS summary statistics, for subsequent multi-trait GWAS. 
Currently, the package only analyzes summary statistics from inverse-Gaussianized continuous traits.
}
\examples{
\dontrun{
## download the six example files from:
## https://www.dropbox.com/sh/hhta45cewvvea2s/AADfj4OXlbroToZAwIii2Buha?dl=0
## the summary statistics from Randall et al. (2013) PLoS Genet
## for males only
## bmi: body mass index
## hip: hip circumference
## wc: waist circumference
## whr: waist-hip ratio

## load the prepared set of independent SNPs
indep.snps <- as.character(read.table('indep.snps')$V1)

## load summary statistics of the six traits
stats.male <- load.summary(files = list.files(pattern = '*.txt'), indep.snps = indep.snps)

## perform multi-trait meta-GWAS
result <- MultiSummary(stats.male)
head(result)
}
}
\references{
Xia Shen, Yakov Tsepilov, ..., Yudi Pawitan, Chris S. Haley, Yurii S. Aulchenko (2017).
Discovery, replication, and in silico functional investigation of 
22 new pleiotropic anthropometric loci. \emph{Submitted}.
}
\seealso{
\code{MultiSummary}
}
\author{
Xia Shen, Yakov, Tsepilov, Yurii S. Aulchenko
}
\keyword{meta-analysis}
\keyword{multivariate,}
