% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiLoad.R
\name{MultiLoad}
\alias{MultiLoad}
\alias{MultiLoad,}
\alias{multiload}
\title{Load individual-level data for multivariate GWA analysis}
\usage{
MultiLoad(gwaa.data = NULL, phenofile = NULL, genofile = NULL, trait.cols,
  covariate.cols = NULL, cuts = 20, impute = TRUE, gaussianize = TRUE,
  ...)
}
\arguments{
\item{gwaa.data}{An (optional) object of \code{{gwaa.data-class}}.}

\item{phenofile}{An (optional) plain text file contains phenotypic outcomes and covariates.}

\item{genofile}{An (optional) object of \code{{databel-class}} containing genotype data.}

\item{trait.cols}{A vector (length > 1) giving the column indices of the phenotypes to be analyzed.}

\item{covariate.cols}{An (optional) vector giving the column indices of the covariates to be included.}

\item{cuts}{An integer telling how many pieces the genotype data matrix will be splitted for analyze.
The value can be set depending on the memory size. The smaller the value is, potentially the faster
the analysis will be.}

\item{impute}{An (optional) logical argument telling whether missing genotypes should be imputed.}

\item{gaussianize}{An (optional) logical argument telling whether the phenotypes should be gaussianized
via inverse-Gaussian transformation.}

\item{...}{not used.}
}
\value{
The function returns a list of cleaned statistics for subsequent, with class \code{multi.loaded}.
}
\description{
The function imports GenABEL (gwaa.data class) or DatABEL (.fv*) data formats
to perform multivariate test for each genetic variant.
}
\note{
Either \code{gwaa.data} (for GenABEL data format) or the combination of 
\code{phenofile} and \code{genofile} (for DatABEL data format) has to be provided.
If all are provided, only \code{phenofile} and \code{genofile} will be used. When using
DatABEL format input, individual IDs in \code{phenofile} and \code{genofile} have to match!
}
\examples{

## loading example gwaa.data in GenABEL
require(GenABEL)
data(ge03d2ex.clean)

## running multivariate GWAS for 3 traits: height, weight, bmi
loaded <- MultiLoad(gwaa.data = ge03d2ex.clean, trait.cols = c(5, 6, 8), 
                    covariate.cols = c(2, 3))

\dontrun{
## converting the same dataset into DatABEL format files
require(DatABEL)
write.table(phdata(ge03d2ex.clean), 'pheno.txt', col.names = TRUE, row.names = TRUE, 
            quote = FALSE, sep = '\\t')
geno <- as.double(ge03d2ex.clean)
matrix2databel(geno, 'geno')

## running the multivariate GWAS again
loaded <- MultiLoad(phenofile = 'pheno.txt', genofile = 'geno', trait.cols = c(5, 6, 8), 
                    covariate.cols = c(2, 3))
}
}
\references{
Xia Shen, ..., Jim Wilson, Gordan Lauc, Yurii Aulchenko (2015).
Multi-omic-variate analysis identified novel loci associated with 
compound N-Glycosylation of human Immunoglobulin G. \emph{Submitted}.
}
\seealso{
\code{\link{Multivariate}}
}
\author{
Xia Shen
}
\keyword{load}
\keyword{multiload,}
\keyword{multivariate,}
