% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{isEmpty}
\alias{isEmpty}
\title{Check whether a useable function argument was provided}
\usage{
isEmpty(arg)
}
\arguments{
\item{arg}{A function argument}
}
\value{
Logical vector of length 1.
}
\description{
This is a simple utility to check whether a function argument is missing,
\code{NULL}, or has only \code{NA}s.
}
\examples{
\dontrun{
f1 <- function(x) {
  if (!isEmpty(x)) return(mean(x, na.rm = TRUE))
  return(NULL)
}

f1()                 #> NULL
f1(x = NA)           #> NULL
f1(x = NULL)         #> NULL
f1(x = c(NA, 1:2))   #> 1.5
}
}
\keyword{internal}
