% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtures.R
\name{mixtureSummaryTable}
\alias{mixtureSummaryTable}
\title{Create a summary table of Mplus mixture models}
\usage{
mixtureSummaryTable(
  modelList,
  keepCols = c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC", "Entropy",
    "T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N", "max_N", "min_prob",
    "max_prob")
)
}
\arguments{
\item{modelList}{A list of models returned from the
\code{extractModelSummaries} function.}

\item{keepCols}{A vector of character strings indicating which
columns/variables to display in the summary. Only columns included in this
list will be displayed (all others excluded). By default, \code{keepCols} is:
\code{c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC","Entropy",
"T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N", "max_N",
"min_prob", "max_prob")}.}
}
\value{
An object of class data.frame.
}
\description{
Creates a summary table of model fit statistics and relevant diagnostic
information for a list of mixture models. Default statistics reported are in
line with published guidelines (see Jung & Wickrama, 2008; Nylund et al.,
2007): \code{c("Title", "Classes", "Warnings", "AIC", "BIC", "aBIC",
"Entropy", "T11_VLMR_PValue", "T11_LMR_PValue", "BLRT_PValue", "min_N",
"max_N", "min_prob", "max_prob")}. The table is customizable using the
\code{keepCols} parameter, which is passed through to \link{SummaryTable}.
}
\note{
This function is partially a wrapper around SummaryTable, with
enhancements for summarizing mixture models.
}
\examples{
\dontrun{
createMixtures(classes = 1:3, filename_stem = "iris", rdata = iris)
runModels(filefilter = "iris")
results <- readModels(filefilter = "iris")
mixtureSummaryTable(results)
createMixtures(classes = 1:3, filename_stem = "iris", rdata = iris,
               OUTPUT = "tech11 tech14;")
runModels(filefilter = "iris", replaceOutfile = "modifiedDate")
results <- readModels(filefilter = "iris")[c(1:2)]
mixtureSummaryTable(results)
}
}
\seealso{
\code{\link{SummaryTable}}
}
\author{
Caspar J. van Lissa
}
\keyword{mixture}
\keyword{mplus}
