% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.R
\name{createSyntax}
\alias{createSyntax}
\title{Create the Mplus input text for an mplusObject}
\usage{
createSyntax(object, filename, check = TRUE, add = FALSE, imputed = FALSE)
}
\arguments{
\item{object}{An object of class mplusObject}

\item{filename}{The name of the data file as a character vector}

\item{check}{A logical indicating whether or not to run \code{parseMplus}
on the created input file. Checks for errors like lines that are too long,
or for missing semi-colons and gives notes.}

\item{add}{A logical passed on to \code{parseMplus} whether to add semi
colons to line ends. Defaults to \code{FALSE}.}

\item{imputed}{A logical whether the data are multiply imputed.
Defaults to \code{FALSE}.}
}
\value{
A character string containing all the text for the Mplus
  input file.
}
\description{
This function takes an object of class \code{mplusObject} and creates
the Mplus input text corresponding to it, including data link and
variable names.
}
\examples{
# example mplusObject
example1 <- mplusObject(MODEL = "mpg ON wt;",
  usevariables = c("mpg", "hp"), rdata = mtcars)

# create the Mplus input text
cat(createSyntax(example1, "example1.dat"), fill=TRUE)

# update the object, then create input text
cat(createSyntax(update(example1,
  TITLE = ~ "This is my title;",
  MODEL = ~ . + "\\nmpg ON hp;",
  usevariables = c("mpg", "hp", "wt")), "example1.dat"),
  fill=TRUE)
rm(example1)
}
\author{
Joshua F. Wiley <jwiley.psych@gmail.com>
}
\seealso{
\code{\link{prepareMplusData}}, \code{\link{mplusModeler}}
}
\keyword{interface}

