\name{getSavedata_Fileinfo}
\Rdversion{1.1}
\alias{getSavedata_Fileinfo}
\title{
Read Variable Names, Formats, and Widths from data generated by the SAVEDATA Command
}
\description{
This function reads the SAVEDATA INFORMATION section from an Mplus output file that used
the SAVEDATA command, and it returns a list with the filename, variable names, variable formats,
and variable widths of the SAVEDATA file.  
}
\usage{
getSavedata_Fileinfo(outfile)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{outfile}{required. The name of the Mplus output file to read. Can be an absolute or relative path.
  If \code{outfile} is a relative path or just the filename, then it is assumed that the file resides in
  the working directory \code{getwd()}.}
}
\value{
Returns a list of SAVEDATA file information that includes:
\item{fileName}{The name of the file containing the analysis dataset created by the Mplus SAVEDATA command.}
\item{varNames}{A character vector containing the names of variables in the dataset.}
\item{varFormats}{A character vector containing the Fortran-style formats of variables in the dataset.}
\item{varWidths}{A numeric vector containing the widths of variables in the dataset (which is stored in fixed-width format).}
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{Michael Hallquist}

\seealso{
\code{\link{getSavedata_Data}}
}
%\examples{
%fileInfo <- getSavedata_Fileinfo("C:/Program Files/Mplus/Test Output.out")
%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{interface}
