% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{selectTracks}
\alias{selectTracks}
\title{Select Tracks by Measure Values}
\usage{
selectTracks(x, measure, lower, upper)
}
\arguments{
\item{x}{the input tracks.}

\item{measure}{measure on which the selection is based (see \link{TrackMeasures}).}

\item{lower}{specifies the lower bound (inclusive) of the allowable measure.}

\item{upper}{specifies the upper bound (inclusive) of the allowable measure.}
}
\description{
Given a tracks object, extract a subset based on upper and lower bounds of a certain
measure. For instance, extract all tracks with a certain minimum length.
}
\examples{
## Slower half of T cells
slow.tcells <- selectTracks( TCells, speed, -Inf, median( sapply(TCells,speed) ) )
}

