% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-mosaic.R
\name{mosaic_engine}
\alias{mosaic_engine}
\alias{mosaic}
\alias{mosaic.Out}
\alias{mosaic.Opn}
\alias{mosaic.Ldk}
\title{Plots mosaics of shapes.}
\usage{
mosaic_engine(
  coo_list,
  dim,
  asp = 1,
  byrow = TRUE,
  fromtop = TRUE,
  sample = 60,
  relatively = FALSE,
  template_size = 0.92
)

mosaic(x, ...)

\method{mosaic}{Out}(
  x,
  f,
  relatively = FALSE,
  pal = pal_qual,
  sample = 60,
  paper_fun = paper_white,
  draw_fun = draw_outlines,
  legend = TRUE,
  dim = NA,
  asp = 1,
  byrow = TRUE,
  fromtop = TRUE,
  ...
)

\method{mosaic}{Opn}(
  x,
  f,
  relatively = FALSE,
  pal = pal_qual,
  sample = 60,
  paper_fun = paper_white,
  draw_fun = draw_curves,
  legend = TRUE,
  dim = NA,
  asp = 1,
  byrow = TRUE,
  fromtop = TRUE,
  ...
)

\method{mosaic}{Ldk}(
  x,
  f,
  relatively = FALSE,
  pal = pal_qual,
  sample = 60,
  paper_fun = paper_white,
  draw_fun = draw_landmarks,
  legend = TRUE,
  dim = NA,
  asp = 1,
  byrow = TRUE,
  fromtop = TRUE,
  ...
)
}
\arguments{
\item{coo_list}{\code{list} of shapes}

\item{dim}{\code{numeric} of length 2, the desired dimensions for rows and columns}

\item{asp}{\code{numeric} the yx ratio used to calculate \code{dim} (1 by default).}

\item{byrow}{\code{logical} whether to order shapes by rows}

\item{fromtop}{\code{logical} whether to order shapes from top}

\item{sample}{\code{numeric} number of points to \link{coo_sample}}

\item{relatively}{\code{logical} if \code{TRUE} use \link{coo_template_relatively}
or, if \code{FALSE}(by default) \link{coo_template}.
In other words, whether to preserve size or not.}

\item{template_size}{\code{numeric} to feed \verb{coo_template(_relatively)}.
Only useful to add padding around shapes when the default value (0.95) is lowered.}

\item{x}{any \link{Coo} object}

\item{...}{additional arguments to feed the main drawer
if the number of shapes is > 1000 (default: 64).
If non-numeric (eg \code{FALSE}) do not sample.}

\item{f}{factor specification to feed \link{fac_dispatcher}}

\item{pal}{one of \link{palettes}}

\item{paper_fun}{a \link{papers} function (default: \code{paper})}

\item{draw_fun}{one of \link{drawers} for \code{pile.list}}

\item{legend}{\code{logical} whether to draw a legend (will be improved in further versions)}
}
\value{
a list of templated and translated shapes
}
\description{
Will soon replace \link{panel}. See examples and vignettes.
}
\examples{

# On Out ---
bot \%>\% mosaic
bot \%>\% mosaic(~type)

# As with other grindr functions you can continue the pipe
bot \%>\% mosaic(~type, asp=0.5) \%>\% draw_firstpoint

# On Opn ---- same grammar
olea \%>\% mosaic(~view+var, paper_fun=paper_dots)

 # On Ldk
 mosaic(wings, ~group, pal=pal_qual_Dark2, pch=3)

 # On Out with different sizes
 # would work on other Coo too
shapes2 <- shapes
sizes <- runif(30, 1, 2)
shapes2 \%>\% mosaic(relatively=FALSE)
shapes2 \%>\% mosaic(relatively=TRUE) \%>\% draw_centroid()
}
\seealso{
Other grindr: 
\code{\link{drawers}},
\code{\link{layers_morphospace}},
\code{\link{layers}},
\code{\link{papers}},
\code{\link{pile}()},
\code{\link{plot_LDA}()},
\code{\link{plot_NMDS}()},
\code{\link{plot_PCA}()}
}
\concept{grindr}
