% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_perim}
\alias{coo_perim}
\alias{coo_perimpts}
\alias{coo_perimpts.default}
\alias{coo_perimpts.Coo}
\alias{coo_perimcum}
\alias{coo_perimcum.default}
\alias{coo_perimcum.Coo}
\alias{coo_perim.default}
\alias{coo_perim.Coo}
\title{Calculates perimeter and variations}
\usage{
coo_perimpts(coo)

\method{coo_perimpts}{default}(coo)

\method{coo_perimpts}{Coo}(coo)

coo_perimcum(coo)

\method{coo_perimcum}{default}(coo)

\method{coo_perimcum}{Coo}(coo)

coo_perim(coo)

\method{coo_perim}{default}(coo)

\method{coo_perim}{Coo}(coo)
}
\arguments{
\item{coo}{\code{matrix} of (x; y) coordinates or any \code{Coo}}
}
\value{
\code{numeric} the distance between every point or
a \code{list} of those.
}
\description{
\code{coo_perim} calculates the perimeter;
\code{coo_perimpts} calculates the euclidean distance between every points of a shape;
\code{coo_perimcum} does the same and calculates and cumulative sum.
}
\examples{
# for speed sake
b1 <- coo_sample(bot[1], 12)
b5 <- bot \%>\% slice(1:5) \%>\% coo_sample(12)

# coo_perim
coo_perim(b1)
coo_perim(b5)

# coo_perimpts
coo_perimpts(b1)
b5 \%>\% coo_perimpts()

# coo_perimcum
b1 \%>\% coo_perimcum()
b5 \%>\% coo_perimcum()
}
\seealso{
Other coo_ utilities: 
\code{\link{coo_aligncalliper}()},
\code{\link{coo_alignminradius}()},
\code{\link{coo_alignxax}()},
\code{\link{coo_align}()},
\code{\link{coo_baseline}()},
\code{\link{coo_bookstein}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_calliper}()},
\code{\link{coo_centdist}()},
\code{\link{coo_center}()},
\code{\link{coo_centpos}()},
\code{\link{coo_close}()},
\code{\link{coo_down}()},
\code{\link{coo_dxy}()},
\code{\link{coo_extract}()},
\code{\link{coo_flipx}()},
\code{\link{coo_force2close}()},
\code{\link{coo_interpolate}()},
\code{\link{coo_is_closed}()},
\code{\link{coo_jitter}()},
\code{\link{coo_left}()},
\code{\link{coo_likely_clockwise}()},
\code{\link{coo_nb}()},
\code{\link{coo_range}()},
\code{\link{coo_rev}()},
\code{\link{coo_right}()},
\code{\link{coo_rotatecenter}()},
\code{\link{coo_rotate}()},
\code{\link{coo_sample_prop}()},
\code{\link{coo_samplerr}()},
\code{\link{coo_sample}()},
\code{\link{coo_scale}()},
\code{\link{coo_shearx}()},
\code{\link{coo_slice}()},
\code{\link{coo_slidedirection}()},
\code{\link{coo_slidegap}()},
\code{\link{coo_slide}()},
\code{\link{coo_smoothcurve}()},
\code{\link{coo_smooth}()},
\code{\link{coo_template}()},
\code{\link{coo_trans}()},
\code{\link{coo_trimbottom}()},
\code{\link{coo_trimtop}()},
\code{\link{coo_trim}()},
\code{\link{coo_untiltx}()},
\code{\link{coo_up}()},
\code{\link{is_equallyspacedradii}()}
}
\concept{coo_ utilities}
\concept{perimeter functions}
