% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-utils.R
\name{coeff_rearrange}
\alias{coeff_rearrange}
\title{Rearrange a matrix of (typically Fourier) coefficients}
\usage{
coeff_rearrange(x, by = c("name", "rank")[1])
}
\arguments{
\item{x}{matrix (with colnames)}

\item{by}{character either "name" (\code{A1, A2, ..}) or "rank" (\code{A1, B1, ...})}
}
\description{
Momocs uses colnamed matrices to store (typically) Fourier coefficients
in \link{Coe} objects (typically \link{OutCoe}). They are arranged as rank-wise:
\code{A1, A2, ..., An, B1, ..., Bn, C1, ..., Cn, D1, ..., Dn}. From other softwares they may arrive
as \code{A1, B1, C1, D1, ..., An, Bn, Cn, Dn}, this functions helps to go
from one to the other format. In short, this function rearranges column order. See examples.
}
\examples{
m_name <- m_rank <- matrix(1:32, 2, 16)
# this one is ordered by name
colnames(m_name) <- paste0(rep(letters[1:4], each=4), 1:4)
# this one is ordered by rank
colnames(m_rank) <- paste0(letters[1:4], rep(1:4, each=4))

m_rank
m_rank \%>\% coeff_rearrange(by="name")
m_rank \%>\% coeff_rearrange(by="rank") #no change

m_name
m_name \%>\% coeff_rearrange(by="name") # no change
m_name \%>\% coeff_rearrange(by="rank")
}
