% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-PCA.R
\name{plot.PCA}
\alias{plot.PCA}
\title{Plots Principal Component Analysis}
\usage{
\method{plot}{PCA}(
  x,
  fac,
  xax = 1,
  yax = 2,
  points = TRUE,
  col = "#000000",
  pch = 20,
  cex = 0.5,
  palette = col_solarized,
  center.origin = FALSE,
  zoom = 1,
  xlim = NULL,
  ylim = NULL,
  bg = par("bg"),
  grid = TRUE,
  nb.grids = 3,
  morphospace = TRUE,
  pos.shp = c("range", "full", "circle", "xy", "range_axes", "full_axes")[1],
  amp.shp = 1,
  size.shp = 1,
  nb.shp = 12,
  nr.shp = 6,
  nc.shp = 5,
  rotate.shp = 0,
  flipx.shp = FALSE,
  flipy.shp = FALSE,
  pts.shp = 60,
  border.shp = col_alpha("#000000", 0.5),
  lwd.shp = 1,
  col.shp = col_alpha("#000000", 0.95),
  stars = FALSE,
  ellipses = FALSE,
  conf.ellipses = 0.5,
  ellipsesax = FALSE,
  conf.ellipsesax = c(0.5, 0.9),
  lty.ellipsesax = 1,
  lwd.ellipsesax = sqrt(2),
  chull = FALSE,
  chull.lty = 1,
  chull.filled = TRUE,
  chull.filled.alpha = 0.92,
  density = FALSE,
  lev.density = 20,
  contour = FALSE,
  lev.contour = 3,
  n.kde2d = 100,
  delaunay = FALSE,
  loadings = FALSE,
  labelspoints = FALSE,
  col.labelspoints = par("fg"),
  cex.labelspoints = 0.6,
  abbreviate.labelspoints = TRUE,
  labelsgroups = TRUE,
  cex.labelsgroups = 0.8,
  rect.labelsgroups = FALSE,
  abbreviate.labelsgroups = FALSE,
  color.legend = FALSE,
  axisnames = TRUE,
  axisvar = TRUE,
  unit = FALSE,
  eigen = TRUE,
  rug = TRUE,
  title = substitute(x),
  box = TRUE,
  old.par = TRUE,
  ...
)
}
\arguments{
\item{x}{\code{PCA}, typically obtained with \link{PCA}}

\item{fac}{name or the column id from the $fac slot, or a formula combining colum names
from the $fac slot (cf. examples). A factor or a numeric of the same length
can also be passed on the fly.}

\item{xax}{the first PC axis}

\item{yax}{the second PC axis}

\item{points}{logical whether to plot points}

\item{col}{a color for the points (either global, for every level of the fac
or for every individual, see examples)}

\item{pch}{a pch for the points (either global, for every level of the fac
or for every individual, see examples)}

\item{cex}{the size of the points}

\item{palette}{a \link{palette}}

\item{center.origin}{logical whether to center the plot onto the origin}

\item{zoom}{to keep your distances}

\item{xlim}{numeric of length two ; if provided along with ylim, the x and y lims to use}

\item{ylim}{numeric of length two ; if provided along with xlim, the x and y lims to use}

\item{bg}{color for the background}

\item{grid}{logical whether to draw a grid}

\item{nb.grids}{and how many of them}

\item{morphospace}{logical whether to add the morphological space}

\item{pos.shp}{passed to \link{morphospace_positions}, one of
\code{"range", "full", "circle", "xy", "range_axes", "full_axes"}. Or directly
a matrix of positions. See \link{morphospace_positions}}

\item{amp.shp}{amplification factor for shape deformation}

\item{size.shp}{the size of the shapes}

\item{nb.shp}{(pos.shp="circle") the number of shapes on the compass}

\item{nr.shp}{(pos.shp="full" or "range) the number of shapes per row}

\item{nc.shp}{(pos.shp="full" or "range) the number of shapes per column}

\item{rotate.shp}{angle in radians to rotate shapes (if several methods, a vector of angles)}

\item{flipx.shp}{same as above, whether to apply coo_flipx}

\item{flipy.shp}{same as above, whether to apply coo_flipy}

\item{pts.shp}{the number of points fro drawing shapes}

\item{border.shp}{the border color of the shapes}

\item{lwd.shp}{the line width for these shapes}

\item{col.shp}{the color of the shapes}

\item{stars}{logical whether to draw "stars"}

\item{ellipses}{logical whether to draw confidence ellipses}

\item{conf.ellipses}{numeric the quantile for the (bivariate gaussian) confidence ellipses}

\item{ellipsesax}{logical whether to draw ellipse axes}

\item{conf.ellipsesax}{one or more numeric, the quantiles for the (bivariate gaussian) ellipses axes}

\item{lty.ellipsesax}{if yes, the lty with which to draw these axes}

\item{lwd.ellipsesax}{if yes, one or more numeric for the line widths}

\item{chull}{logical whether to draw a convex hull}

\item{chull.lty}{if yes, its linetype}

\item{chull.filled}{logical whether to add filled convex hulls}

\item{chull.filled.alpha}{numeric alpha transparency}

\item{density}{whether to add a 2d density kernel estimation (based on \link{kde2d})}

\item{lev.density}{if yes, the number of levels to plot (through \link{image})}

\item{contour}{whether to add contour lines based on 2d density kernel}

\item{lev.contour}{if yes, the (approximate) number of lines to draw}

\item{n.kde2d}{the number of bins for \link{kde2d}, ie the 'smoothness' of density kernel}

\item{delaunay}{logical whether to add a delaunay 'mesh' between points}

\item{loadings}{logical whether to add loadings for every variables}

\item{labelspoints}{if TRUE rownames are used as labels, a colname from $fac can also be passed}

\item{col.labelspoints}{a color for these labels, otherwise inherited from fac}

\item{cex.labelspoints}{a cex for these labels}

\item{abbreviate.labelspoints}{logical whether to abbreviate}

\item{labelsgroups}{logical whether to add labels for groups}

\item{cex.labelsgroups}{ifyes, a numeric for the size of the labels}

\item{rect.labelsgroups}{logical whether to add a rectangle behind groups names}

\item{abbreviate.labelsgroups}{logical, whether to abbreviate group names}

\item{color.legend}{logical whether to add a (cheap) color legend for numeric fac}

\item{axisnames}{logical whether to add PC names}

\item{axisvar}{logical whether to draw the variance they explain}

\item{unit}{logical whether to add plane unit}

\item{eigen}{logical whether to draw a plot of the eigen values}

\item{rug}{logical whether to add rug to margins}

\item{title}{character a name for the plot}

\item{box}{whether to draw a box around the plotting region}

\item{old.par}{whether to restore the old \link{par}. Set it to \code{FALSE} if you want to reuse the graphical window.}

\item{...}{useless here, just to fit the generic plot}
}
\description{
The Momocs' \code{\link{PCA}} plotter with morphospaces and many graphical options.
}
\details{
Widely inspired by the "layers" philosophy behind graphical functions
of the ade4 R package.
}
\note{
NAs is \code{$fac} are handled quite experimentally.
More importantly, as of early 2018, I plan I complete rewrite of
\code{plot.PCA} and other multivariate plotters.
}
\examples{
\dontrun{
bot.f <- efourier(bot, 12)
bot.p <- PCA(bot.f)

### Morphospace options
plot(bot.p, pos.shp="full")
plot(bot.p, pos.shp="range")
plot(bot.p, pos.shp="xy")
plot(bot.p, pos.shp="circle")
plot(bot.p, pos.shp="range_axes")
plot(bot.p, pos.shp="full_axes")

plot(bot.p, morpho=FALSE)

### Passing factors to plot.PCA
# 3 equivalent methods
plot(bot.p, "type")
plot(bot.p, 1)
plot(bot.p, ~type)

# let's create a dummy factor of the correct length
# and another added to the $fac with mutate
# and a numeric of the correct length
f <- factor(rep(letters[1:2], 20))
z <- factor(rep(LETTERS[1:2], 20))
bot \%<>\% mutate(cs=coo_centsize(.), z=z)
bp <- bot \%>\% efourier \%>\% PCA
# so bp contains type, cs (numeric) and z; not f
# yet f can be passed on the fly
plot(bp, f)
# numeric fac are allowed
plot(bp, "cs", cex=3, color.legend=TRUE)
# formula allows combinations of factors
plot(bp, ~type+z)

### other morphometric approaches works the same
# open curves
op <- npoly(olea, 5)
op.p <- PCA(op)
op.p
plot(op.p, ~ domes + var, morpho=TRUE) # use of formula

# landmarks
wp <- fgProcrustes(wings, tol=1e-4)
wpp <- PCA(wp)
wpp
plot(wpp, 1)

# traditionnal measurements
flower \%>\% PCA \%>\% plot(1)

# plot.PCA can be used after a PCA
PCA(iris[, 1:4], fac=iris$Species)  \%>\% plot(1)

### Cosmetic options
# window
plot(bp, 1, zoom=2)
plot(bp, zoom=0.5)
plot(bp, center.origin=FALSE, grid=FALSE)

# colors
plot(bp, col="red") # globally
plot(bp, 1, col=c("#00FF00", "#0000FF")) # for every level
# a color vector of the right length
plot(bp, 1, col=rep(c("#00FF00", "#0000FF"), each=20))
# a color vector of the right length, mixign Rcolor names (not a good idea though)
plot(bp, 1, col=rep(c("#00FF00", "forestgreen"), each=20))


# ellipses
plot(bp, 1, conf.ellipsesax=2/3)
plot(bp, 1, ellipsesax=FALSE)
plot(bp, 1, ellipsesax=TRUE, ellipses=TRUE)

# stars
plot(bp, 1, stars=TRUE, ellipsesax=FALSE)

# convex hulls
plot(bp, 1, chull=TRUE)
plot(bp, 1, chull.lty=3)

# filled convex hulls
plot(bp, 1, chull.filled=TRUE)
plot(bp, 1, chull.filled.alpha = 0.8, chull.lty =1) # you can omit chull.filled=TRUE

# density kernel
plot(bp, 1, density=TRUE, contour=TRUE, lev.contour=10)

# delaunay
plot(bp, 1, delaunay=TRUE)

# loadings
flower \%>\% PCA \%>\% plot(1, loadings=TRUE)

# point/group labelling
plot(bp, 1, labelspoint=TRUE) # see options for abbreviations
plot(bp, 1, labelsgroup=TRUE) # see options for abbreviations

# clean axes, no rug, no border, random title
plot(bp, axisvar=FALSE, axisnames=FALSE, rug=FALSE, box=FALSE, title="random")

# no eigen
plot(bp, eigen=FALSE) # eigen cause troubles to graphical window
# eigen may causes troubles to the graphical window. you can try old.par = TRUE
}
}
\seealso{
\link{plot.LDA}
}
