% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-LDA.R
\name{classification_metrics}
\alias{classification_metrics}
\title{Calculate classification metrics on a confusion matrix}
\usage{
classification_metrics(x)
}
\arguments{
\item{x}{a \code{table} or an \link{LDA} object}
}
\value{
a list with the following components is returned:
\enumerate{
\item \code{accuracy}  the fraction of instances that are correctly classified
\item \code{macro_prf} data.frame containing \code{precision}
(the fraction of correct predictions for a certain class);
\code{recall}, the fraction of instances of a class that were correctly predicted;
\code{f1} the harmonic mean (or a weighted average) of precision and recall.
\item \code{macro_avg}, just the average of the three \code{macro_prf} indices
\item \code{ova} a list of one-vs-all confusion matrices for each class
\item \code{ova_sum} a single of all ova matrices
\item \code{kappa} measure of agreement between the predictions and the actual labels
}
}
\description{
In some cases, the class correctness or the proportion of correctly classified
individuals is not enough, so here are more detailed metrics when working on classification.
}
\examples{
# some morphometrics on 'hearts'
hearts \%>\% fgProcrustes(tol=1) \%>\%
coo_slide(ldk=1) \%>\% efourier(norm=FALSE) \%>\% PCA() \%>\%
# now the LDA and its summary
LDA(~aut) \%>\% classification_metrics()
}
\seealso{
The pages below are of great interest to understand these metrics. The code
used is partley derived from the Revolution Analytics blog post (with their authorization). Thanks to them!
\enumerate{
\item \url{https://en.wikipedia.org/wiki/Precision_and_recall}
\item \url{http://blog.revolutionanalytics.com/2016/03/com_class_eval_metrics_r.html}
\item \url{http://www.r-bloggers.com/is-your-classification-model-making-lucky-guesses/}
}

Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEANS}()},
\code{\link{KMEDOIDS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{NMDS}()},
\code{\link{PCA}()}
}
\concept{multivariate}
