% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{sample_frac}
\alias{sample_frac}
\title{Samples a fraction of shapes in Momocs objects}
\usage{
sample_frac(tbl, size, replace, fac, ...)
}
\arguments{
\item{tbl}{a Momocs object (Coo, Coe)}

\item{size}{numeric (0 < numeric <= 1) the fraction of shapes to select}

\item{replace}{logical whether sample should be done with ot without replacement}

\item{fac}{a column name if a \code{$fac} is defined; size is then applied within levels of this factor}

\item{...}{additional arguments to dplyr::sample_frac and to maintain generic compatibility}
}
\description{
Sample a fraction of shapes from a Momocs object. See examples and \code{?dplyr::sample_n}.
}
\note{
the resulting fraction is rounded with \link{ceiling}.
}
\examples{

data(bot)
bot
# samples 50\% of the bottles no matter their type
sample_frac(bot, 0.5)
# 80\% bottles of beer and of whisky
table(sample_frac(bot, 0.8, fac="type"))
# bootstrap the same number of bootles of each type but with replacement
table(names(sample_frac(bot, 1, replace=TRUE)))

}
\seealso{
Other handling functions: \code{\link{arrange}},
  \code{\link{at_least}}, \code{\link{chop}},
  \code{\link{combine}}, \code{\link{dissolve}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{rename}}, \code{\link{rm_uncomplete}},
  \code{\link{rw_fac}}, \code{\link{sample_n}},
  \code{\link{select}}, \code{\link{slice}},
  \code{\link{subset.Coo}}
}
