% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-sfourier.R
\name{sfourier}
\alias{sfourier}
\alias{sfourier.Out}
\alias{sfourier.default}
\title{Radii variation Fourier transform (equally spaced curvilinear abscissa)}
\usage{
sfourier(x, nb.h)

\method{sfourier}{default}(x, nb.h)

\method{sfourier}{Out}(x, nb.h)
}
\arguments{
\item{x}{A \code{list} or \code{matrix} of coordinates or an \code{Out} object}

\item{nb.h}{\code{integer}. The number of harmonics to use. If missing, 12 is used on shapes;
99 percent of harmonic power on Out objects, both with messages.}
}
\value{
A list with following components:
\itemize{
 \item \code{an} vector of \eqn{a_{1->n}} harmonic coefficients
 \item \code{bn} vector of \eqn{b_{1->n}} harmonic coefficients
 \item \code{ao} ao harmonic coefficient
 \item \code{r} vector of radii lengths
 }
}
\description{
\code{sfourier} computes radii variation Fourier analysis from a matrix or a
list of coordinates where points are equally spaced aong the curvilinear abscissa.
}
\note{
The implementation is still quite experimental (as of Dec. 2016)
}
\examples{
molars[4] \%>\% coo_center \%>\% coo_scale \%>\% coo_interpolate(1080) \%>\% coo_slidedirection("E") \%>\%
   coo_sample(360) \%T>\% coo_plot(zoom=2) \%>\% sfourier(16) \%>\%
   sfourier_i() \%>\% coo_draw(bor="red", points=TRUE)
}
\references{
Renaud S, Pale JRM, Michaux JR (2003): Adaptive latitudinal trends in the mandible shape
of \emph{Apodemus} wood mice. \emph{J Biogeogr} 30:1617-1628.
}
\seealso{
Other sfourier: \code{\link{sfourier_i}},
  \code{\link{sfourier_shape}}
}

