% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_scalex}
\alias{coo_scalex}
\alias{coo_scaley}
\title{Shrinks coordinates in one direction}
\usage{
coo_scalex(coo, k = 1)

coo_scaley(coo, k = 1)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a \code{list}, or any \link{Coo} object.}

\item{k}{\code{numeric} scaling factor}
}
\value{
a \code{matrix} of (x; y) coordinates, or a \link{Coo} object.
}
\description{
\code{coo_scalex} applies a scaling parallel to the x-axis to a matrix of (x; y)
or a list of coordinates or any Coo object, \code{coo_scaley} does it parallel to the y-axis.
}
\examples{
coo <- shapes[11] \%>\% coo_template()
coo_plot(coo, xlim=c(-1, 1))
coo \%>\% coo_scalex(1.5) \%>\% coo_draw(border="blue")
coo \%>\% coo_scaley(1.5) \%>\% coo_draw(border="red")
coo \%>\% coo_scalex(0.5) \%>\% coo_draw(border="blue", lty=2)
coo \%>\% coo_scaley(0.5) \%>\% coo_draw(border="red", lty=2)
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_centsize}}, \code{\link{coo_close}},
  \code{\link{coo_down}}, \code{\link{coo_dxy}},
  \code{\link{coo_extract}}, \code{\link{coo_flipx}},
  \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}}, \code{\link{coo_nb}},
  \code{\link{coo_perimcum}}, \code{\link{coo_perimpts}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_samplerr}},
  \code{\link{coo_sample}}, \code{\link{coo_scale}},
  \code{\link{coo_shearx}}, \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_closed}}

Other scaling functions: \code{\link{coo_scale}},
  \code{\link{coo_template}}
}

