% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Momocs-package.R
\docType{package}
\name{Momocs}
\alias{Momocs}
\alias{Momocs-package}
\title{Momocs}
\description{
A complete toolkit for morphometrics, from data extraction to multivariate analyses.
Most common 2D morphometrics approaches are included:
outlines, open outlines, configurations of landmarks, traditional morphometrics,
and facilities for data preparation, manipulation and visualization
with a consistent grammar throughout.
Momocs allows reproducible, complex morphometric analyses,
paves the way for a pure open-source workflow in R,
and other morphometrics approaches should be easy to plug in,
or develop from, on top of this canvas.
}
\details{
To cite Momocs in publications: \code{citation("Momocs")}.
}
\section{Cheers}{

We are very grateful to (in alphabetical order): Laurent Bouby, Simon Crameri, April Dinwiddie,
Carl Lipo, Cedric Gaucherel, Sarah Ivorra, Glynis Jones, Ricardo Kriebel, Remi Laffont, Fabien Lafuma,
Neus Martinez, Marcelo Reginato, Evan Saitta, David Siddons, Eleanor Stillman,
Theodore Stammer, Norbert Telmon, Jean-Frederic Terral, Bill Venables, Daniele Ventura, Michael Wallace,
Asher Wishkerman, John Wood for their helpful ideas and bug reports.
}
\references{
\itemize{
\item Bonhomme V, Picq S, Gaucherel C, Claude J. 2014. Momocs: Outline Analysis Using R.
\emph{Journal of Statistical Software} \bold{56}. \url{http://www.jstatsoft.org/v56/i13}.
\item Claude J. 2008. \emph{Morphometrics with R}. Springer-Verlag, New-York.
}
}
\seealso{
\itemize{
 \item \bold{Homepage}: \url{https://github.com/vbonhomme/Momocs}
 \item \bold{Issues}: \url{https://github.com/vbonhomme/Momocs/issues}
 \item \bold{Tutorial}: \code{browseVignettes("Momocs")}
 \item \bold{Email}: \code{bonhomme.vincent@gmail.com} to contribute to dev, ask for something, share your data, etc.
}
}

