#' Exemplary Outcome Objects for the MoNAn Package
#'
#' @name myOutcomeObjects
#' @description
#' These are exemplary outcome objects for the MoNAn package and can be used in 
#' order not to run all precedent functions and thus save time. The following 
#' products are provided:
#' 
#' @rdname myOutcomeObjects
#' @usage NULL
#' @format `myState`
#' An object of class "processState.monan" created by the function [createProcessState()].
"myState"


#' @rdname myOutcomeObjects
#' @usage NULL
#' @format `myEffects`
#' An object of class "effectsList.monan" created by the function [createEffectsObject()]
#' or [createEffects()].
"myEffects"


#' @rdname myOutcomeObjects
#' @usage NULL
#' @format `myAlg`
#' An object of class "algorithm.monan" created by the function [createAlgorithm()].
"myAlg"


#' @rdname myOutcomeObjects
#' @usage NULL
#' @format `myResDN`
#' An object of class "result.monan" created by the function [estimateMobilityNetwork()].
"myResDN"


#' @rdname myOutcomeObjects
#' @usage NULL
#' @format `mySimDN`
#' An object of class "sims.monan" created by the function [simulateMobilityNetworks()].
"mySimDN"
