% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_auxiliaryFunctions.R
\name{extractTraces}
\alias{extractTraces}
\alias{plot.traces.monan}
\title{extractTraces}
\usage{
extractTraces(ans, effects)

\method{plot}{traces.monan}(x, ...)
}
\arguments{
\item{ans}{An object of class "result.monan" resulting from an estimation with the function \code{\link[=estimateMobilityNetwork]{estimateMobilityNetwork()}}.}

\item{effects}{An object of class "effectsList.monan" used in the estimation.}

\item{x}{An object of class "traces.monan".}

\item{...}{Additional plotting parameters, use not recommended.}
}
\value{
The function \code{extractTraces} returns a list that includes
(1) the observed statistics for all effects,
(2) the distribution of statistics for all simulations and
(3) effect names.
It is recommended to use the plotting function to inspect the traces.

The function \code{plot.traces.monan} shows a scatter plot of the
statistics of simulated networks from phase three of the esimtation.
}
\description{
This function shows the values of simulated statistics in Phase 3 for subsequent draws from the chain.
Ideally, the plots show points randomly scattered around the red line, which indicates the statistics in the data.
}
\examples{
\donttest{
# regression diagnostics
traces <- extractTraces(myResDN, myEffects)
}
\donttest{
plot(traces)
}
}
\seealso{
\code{\link[=createEffectsObject]{createEffectsObject()}}
}
