% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vibro_exp3}
\alias{vibro_exp3}
\title{Data from tactile discrimination task - (Dallmann et al., 2015).}
\format{
A data frame with 126 rows (14 observations x 9 participants) and 5 variables:
\describe{
\item{speed}{numeric, speed of the moving surface (in cm/s, range \code{c(1,16)})}
\item{vibration}{factor representing the vibration frequency of the masking stimulus. Two levels: 32 (vibration in the experimental condition, in Hz) 
or 0 (no vibration - control condition)}
\item{faster}{proportion of trials in which the comparison stimulus was judged as faster than the reference}
\item{slower}{proportion of trials in which the comparison stimulus was judged as slower than the reference}
\item{subject}{participant's identification code}
}
}
\source{
Original data were published in Dallmann et al. (2015).
}
\usage{
data(vibro_exp3)
}
\description{
A dataset containing the response recorded from a tactile discrimination task (nine participants). In a
 forced-choice experiment, participants were required to discriminate the motion speed of a moving surface by
 touching it. Simultaneously with the motion stimulus, a 32Hz masking vibration occurred in half of the trials.
}
\references{
Dallmann, C. J., Ernst, M. O., & Moscatelli, A. (2015). 
The role of vibration in tactile speed perception. Journal of Neurophysiology, 114(6),
3131–3139. <doi:10.1152/jn.00621.2015>
}
\keyword{datasets}
