% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestIndSerCopulaMulti.R
\name{TestIndSerCopulaMulti}
\alias{TestIndSerCopulaMulti}
\title{Statistics and P-values for a test of randomness for a multivariate time series}
\usage{
TestIndSerCopulaMulti(x, p, trunc.level = 2, B = 1000, graph = FALSE)
}
\arguments{
\item{x}{Time series matrix}

\item{p}{Number of consecutive vectors}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}

\item{B}{Number of multipliers samples (default = 1000)}

\item{graph}{Set to TRUE if one wants the dependogram of P-values for the Moebius statistics}
}
\value{
\item{stat}{List of Cramer-von Mises statistics cvm, tilde Sn, and test combinations tilde Tn and tilde Tn2 (only pairs), as defined in Nasri(2022).}

\item{pvalue}{Approximated P-values for the tests using Gaussian multipliers}
}
\description{
This function computes Cramer-von Mises statistics from the multilinear copula and their combination for a tests of randomness for p consecutives values of random vectors X(1), ..., X(p). The p-values are computed using Gaussian multipliers.
}
\examples{
\donttest{
data(Y)
out <- TestIndSerCopulaMulti(Y,5,5)
}
}
\references{
B.R Nasri (2022). Tests of serial dependence for arbitrary distributions
}
