% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mphd.R
\name{mixOnekn}
\alias{mixOnekn}
\title{Two-component Normal Mixture Estimation with One Known Component}
\usage{
mixOnekn(x, sigma.known = NULL)
}
\arguments{
\item{x}{a vector of observations.}

\item{sigma.known}{standard deviation of the first component (if known). Default is NULL,
which calculates the component standard deviations using the given observations \code{x}.}
}
\value{
A list containing the following elements:
\item{mu}{estimated 2 component means, where the first mean is 0.}
\item{sigma}{estimated 2 component standard deviations.}
\item{pi}{estimated 2 mixing proportions.}
\item{lik}{final likelihood.}
}
\description{
`mixOnekn' is used for the estimation of the following two-component mixture model:
\deqn{h(x;\boldsymbol{\theta},f) = \pi f(x-\mu_1)+(1-\pi)f(x-\mu_2),}
where \eqn{\boldsymbol{\theta}=(\pi,\mu_1,\mu_2)^{\top}} is the parameter to estimate,
\eqn{f} is an unknown density function that is symmetric at zero.
The parameters are estimated by assuming \eqn{f} is the normal density and the
first component has a mean of 0.
This function can be used to obtain initial values for the \code{\link{mixMPHD}} function.
}
\examples{
# see examples for the `mixMPHD' function.
}
\seealso{
\code{\link{mixMPHD}}
}
