% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diso.R
\name{diso}
\alias{diso}
\title{Isotope filtering}
\usage{
diso(iso1, n11, n12, iso2 = "NO", n21 = 0, n22 = 0, exp.base,
  exp.iso, ppm = 30, rt.dif = 6)
}
\arguments{
\item{iso1}{the first labled atom in precusor ion.}

\item{n11}{the maximum numbers of the first labled atoms expected in the labeled intermediates.}

\item{n12}{the minimum numbers of the first labled atoms expected in the labeled intermediates.}

\item{iso2}{the second labled atom in the same precusor ion, default value 'NO' (not exist).}

\item{n21}{the maximum numbers of the second labled atoms expected in the labeled intermediates, default value 0.}

\item{n22}{the minimum numbers of the second labled atoms expected in the labeled intermediates, default value 0.}

\item{exp.base}{the control group (fed with unlabled precusor).}

\item{exp.iso}{isotope labeled group.}

\item{ppm}{m/z tolarance, default value 30.}

\item{rt.dif}{retention time tolarance, default value 6 seconds.}
}
\value{
results containing unlabled and their corresponding labled analytes, with RT and labeling information.
}
\description{
filtering isotopically labeled analytes according to RT and mass differences
}
\examples{
data(lcms)
explist <- prefilter(lcms[1: 100, ]) # use a subset of lcms data as example
exp.B <- explist$exp.B
exp.C <- explist$exp.C
exp.D <- explist$exp.D
iso.C <- diso(iso1 = 'H2', n11 = 4, n12 = 2, exp.base = exp.B, exp.iso = exp.C)
iso.D <- diso(iso1 = 'C13', n11 = 9, n12 = 6, iso2 = 'N15', n21 = 1, n22 = 0,
exp.base = iso.C[,1:3], exp.iso = exp.D)
}
