% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_team.R
\docType{class}
\name{ms_team}
\alias{ms_team}
\title{Microsoft Teams team}
\format{
An R6 object of class \code{ms_team}, inheriting from \code{ms_object}.
}
\description{
Class representing a team in Microsoft Teams.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this team.
\item \code{type}: Always "team" for a team object.
\item \code{properties}: The team properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new team object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete a team. By default, ask for confirmation first.
\item \code{update(...)}: Update the team metadata in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the team.
\item \code{sync_fields()}: Synchronise the R object with the team metadata in Microsoft Graph.
\item \code{list_channels(filter=NULL)}: List the channels for this team. Optionally, supply an OData expression to filter the list.
\item \code{get_channel(channel_name, channel_id)}: Retrieve a channel. If the name and ID are not specified, returns the primary channel.
\item \code{create_channel(channel_name, description, membership)}: Create a new channel. Optionally, you can specify a short text description of the channel, and the type of membership: either standard or private (invitation-only).
\item \code{delete_channel(channel_name, channel_id, confirm=TRUE)}: Delete a channel; by default, ask for confirmation first. You cannot delete the primary channel of a team. Note that Teams keeps track of all channels ever created, even if you delete them (you can see the deleted channels by going to the "Manage team" pane for a team, then the "Channels" tab, and expanding the "Deleted" entry); therefore, try not to create and delete channels unnecessarily.
\item \code{list_drives()}: List the drives (shared document libraries) associated with this team.
\item \code{get_drive(drive_id)}: Retrieve a shared document library for this team. If the ID is not specified, this returns the default document library.
\item \code{get_sharepoint_site()}: Get the SharePoint site associated with the team.
\item \code{get_group()}: Retrieve the Microsoft 365 group associated with the team.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_team} and \code{list_teams} methods of the \code{\link{ms_graph}}, \code{\link{az_user}} or \code{\link{az_group}} classes. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual team.
}

\examples{
\dontrun{

myteam <- get_team("my team")
myteam$list_channels()
myteam$get_channel()
myteam$get_drive()

myteam$create_channel("Test channel", description="A channel for testing")
myteam$delete_channel("Test channel")

}
}
\seealso{
\code{\link{ms_graph}}, \code{\link{az_group}}, \code{\link{ms_channel}}, \code{\link{ms_site}}, \code{\link{ms_drive}}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/resources/teams-api-overview?view=graph-rest-1.0}{Microsoft Teams API reference}
}
