% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_drive_item.R
\docType{class}
\name{ms_drive_item}
\alias{ms_drive_item}
\title{File or folder in a drive}
\format{
An R6 object of class \code{ms_drive_item}, inheriting from \code{ms_object}.
}
\description{
Class representing an item (file or folder) in a OneDrive or SharePoint document library.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for the parent drive.
\item \code{type}: always "drive item" for a drive item object.
\item \code{properties}: The item properties (metadata).
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete this item. By default, ask for confirmation first.
\item \code{update(...)}: Update the item's properties (metadata) in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the item.
\item \code{sync_fields()}: Synchronise the R object with the item metadata in Microsoft Graph.
\item \code{open()}: Open the item in your browser.
\item \code{download(dest, overwrite)}: Download the file. Not applicable for a folder.
\item \code{create_share_link(type, expiry, password, scope)}: Create a shareable link to the file or folder. See 'Sharing' below.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_item} method of the \link{ms_drive} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual item.
}

\section{Sharing}{

\code{create_share_link(type, expiry, password, scope)} returns a shareable link to the item. Its arguments are
\itemize{
\item \code{type}: Either "view" for a read-only link, "edit" for a read-write link, or "embed" for a link that can be embedded in a web page. The last one is only available for personal OneDrive.
\item \code{expiry}: How long the link is valid for. The default is 7 days; you can set an alternative like "15 minutes", "24 hours", "2 weeks", "3 months", etc. To leave out the expiry date, set this to NULL.
\item \code{scope}: Optionally the scope of the link, either "anonymous" or "organization". The latter allows only users in your AAD tenant to access the link, and is only available for OneDrive for Business or SharePoint.
}

This function returns a URL to access the item, for \code{type="view"} or "\verb{type=edit"}. For \code{type="embed"}, it returns a list with components \code{webUrl} containing the URL, and \code{webHtml} containing a HTML fragment to embed the link in an IFRAME.
}

\examples{
\dontrun{

# personal OneDrive
gr2 <- get_graph_login("consumers")
me <- gr2$get_user()
mydrv <- me$get_drive()

myfile <- drv$get_item("myfile.docx")
myfile$properties

# rename a file
myfile$update(name="newname.docx")

# open the file in the browser
myfile$open()

# download the file to the working directory
myfile$download()

# shareable links
myfile$create_share_link()
myfile$create_share_link(type="edit", expiry="24 hours")
myfile$create_share_link(password="Use-strong-passwords!")

# delete the file (will ask for confirmation first)
myfile$delete()

}
}
\seealso{
\link{ms_graph}, \link{ms_site}, \link{ms_drive}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/resources/onedrive?view=graph-rest-1.0}{OneDrive API reference}
}
