% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humans_MOI.R
\name{get_config_humans_MOI}
\alias{get_config_humans_MOI}
\title{Get parameters for MOI human model}
\usage{
get_config_humans_MOI(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have 9 entries:
\itemize{
\item stochastic: a boolean value
\item theta: matrix (row major)
\item wf: vector
\item H: vector
\item MOI: matrix (row major)
\item b: scalar
\item c: scalar
\item r: scalar
\item sigma: scalar
}

For interpretation of the entries, please read \link{setup_humans_MOI}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
n <- 6 # number of human population strata
p <- 5 # number of patches
theta <- matrix(rexp(n*p), nrow = n, ncol = p)
theta <- theta / rowSums(theta)
H <- rep(10, n)
MOI <- matrix(0, nrow = 10, ncol = n)
MOI[1, ] <- H
par <- list(
 "stochastic" = FALSE,
 "theta" = theta,
 "wf" = rep(1, n),
 "H" = H,
 "MOI" = MOI,
 "b" = 0.55,
 "c" = 0.15,
 "r" = 1/200,
 "sigma" = 1
)
toJSON(par, pretty = TRUE)
}
