% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementary_score.R
\name{elementary_score}
\alias{elementary_score}
\alias{elementary_score_expectile}
\alias{elementary_score_quantile}
\title{Elementary Scoring Function for Expectiles and Quantiles}
\usage{
elementary_score_expectile(
  actual,
  predicted,
  w = NULL,
  alpha = 0.5,
  theta = 0,
  ...
)

elementary_score_quantile(
  actual,
  predicted,
  w = NULL,
  alpha = 0.5,
  theta = 0,
  ...
)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{alpha}{Optional level of expectile resp. quantile.}

\item{theta}{Optional parameter.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of the elementary scoring function for expectiles resp. quantiles at level \code{alpha} with parameter \code{theta}, see reference below.
Every choice of \code{theta} gives a scoring function consistent for the expectile resp. quantile at level \code{alpha}.
Note that the expectile at level \code{alpha = 0.5} is the expectation (mean).
The smaller the score, the better.
}
\examples{
elementary_score_expectile(1:10, c(1:9, 12), alpha = 0.5, theta = 11)
elementary_score_quantile(1:10, c(1:9, 12), alpha = 0.5, theta = 11)
}
\references{
Ehm, W., Gneiting, T., Jordan, A. and Krüger, F. (2016), Of quantiles and expectiles: consistent scoring functions, Choquet representations and forecast rankings. J. R. Stat. Soc. B, 78: 505-562, <doi.org/10.1111/rssb.12154>.
}
\seealso{
\code{\link{murphy_diagram}}.
}
