% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde_covariance.R
\name{spde_variance}
\alias{spde_variance}
\title{Variancefor Whittle-Matérn fields}
\usage{
spde_variance(
  kappa,
  tau,
  range,
  sigma,
  alpha,
  graph,
  BC = 1,
  include_vertices = FALSE,
  directional = F
)
}
\arguments{
\item{kappa}{Parameter kappa from the SPDE.}

\item{tau}{Parameter tau from the SPDE.}

\item{range}{Range parameter.}

\item{sigma}{Standard deviation parameter.}

\item{alpha}{Smoothness parameter (1 or 2).}

\item{graph}{A \code{metric_graph} object.}

\item{BC}{boundary conditions}

\item{include_vertices}{Should the variance at the vertices locations be included in the returned vector?}

\item{directional}{bool is the model a directional or not. directional only works for alpha=1}
}
\value{
Vector with the variance function evaluate at the mesh locations.
}
\description{
Computes the variance function for a Whittle-Matérn field.
Warning is not feasible for large graph due to matrix inversion
}
\details{
Compute the variance \eqn{\rho(s_i,s_i)} where
\eqn{s_i} are all locations in the mesh
of the graph.
}
