% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_spde.R
\name{graph_spde}
\alias{graph_spde}
\title{'INLA' implementation of Whittle-Matérn fields for metric graphs}
\usage{
graph_spde(
  graph_object,
  alpha = 1,
  stationary_endpoints = "all",
  parameterization = c("matern", "spde"),
  start_range = NULL,
  prior_range = NULL,
  start_kappa = NULL,
  start_sigma = NULL,
  prior_kappa = NULL,
  prior_sigma = NULL,
  shared_lib = "detect",
  debug = FALSE
)
}
\arguments{
\item{graph_object}{A \code{metric_graph} object.}

\item{alpha}{The order of the SPDE.}

\item{stationary_endpoints}{Which vertices of degree 1 should contain
stationary boundary conditions?}

\item{parameterization}{Which parameterization to be used? The options are
'matern' (sigma and range) and 'spde' (sigma and kappa).}

\item{start_range}{Starting value for range parameter.}

\item{prior_range}{a \code{list} containing the elements \code{meanlog} and
\code{sdlog}, that is, the mean and standard deviation of the range parameter on
the log scale. Will not be used if prior.kappa is non-null.}

\item{start_kappa}{Starting value for kappa.}

\item{start_sigma}{Starting value for sigma.}

\item{prior_kappa}{a \code{list} containing the elements \code{meanlog} and
\code{sdlog}, that is, the mean and standard deviation of kappa on the log scale.}

\item{prior_sigma}{a \code{list} containing the elements \code{meanlog} and
\code{sdlog}, that is, the mean and standard deviation of sigma on the log scale.}

\item{shared_lib}{Which shared lib to use for the cgeneric implementation?
If "detect", it will check if the shared lib exists locally, in which case it will
use it. Otherwise it will use 'INLA's shared library.
If 'INLA', it will use the shared lib from 'INLA's installation. If 'MetricGraph', then
it will use the local installation (does not work if your installation is from CRAN).
Otherwise, you can directly supply the path of the .so (or .dll) file.}

\item{debug}{Should debug be displayed?}
}
\value{
An 'INLA' object.
}
\description{
This function creates an 'INLA' object that can be used
in 'INLA' or 'inlabru' to fit Whittle-Matérn fields on metric graphs.
}
\details{
This function is used to construct a Matern SPDE model on a metric graph.
The latent field \eqn{u} is the solution of the SPDE
\deqn{(\kappa^2 - \Delta)^\alpha u = \sigma W,} where \eqn{W} is Gaussian
white noise on the metric graph. This model implements exactly
the cases in which \eqn{\alpha = 1} or \eqn{\alpha = 2}. For a finite
element approximation for general \eqn{\alpha} we refer the reader to the
'rSPDE' package and to the Whittle--Matérn fields with general smoothness vignette.

We also have the alternative parameterization \eqn{\rho = \frac{\sqrt{8(\alpha-0.5)}}{\kappa}},
which can be interpreted as a range parameter.

Let \eqn{\kappa_0} and \eqn{\sigma_0} be the starting values for \eqn{\kappa} and
\eqn{\sigma}, we write \eqn{\sigma = \exp\{\theta_1\}} and \eqn{\kappa = \exp\{\theta_2\}}.
We assume priors on \eqn{\theta_1} and \eqn{\theta_2} to be normally distributed
with mean, respectively, \eqn{\log(\sigma_0)} and \eqn{\log(\kappa_0)}, and variance 10.
Similarly, if we let \eqn{\rho_0} be the starting value for \eqn{\rho}, then
we write \eqn{\rho = \exp\{\theta_2\}} and assume a normal prior for \eqn{\theta_2},
with mean \eqn{\log(\rho_0)} and variance 10.
}
