% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethComp.R
\name{choose.trans}
\alias{choose.trans}
\title{Functions to handle transformations of measurement results.}
\usage{
choose.trans(tr)
}
\arguments{
\item{tr}{A character string, or a list of two functions, they should be
each other's inverse. Names of the list are ignored.}
}
\value{
\code{choose.trans} returns a named list with two elements "trans"
and "inv", both functions which are each other's inverse. This is intended
to be stored as an attribute \code{"Transform"} with the resulting object
and used in plotting and reporting. All results will be on the transformed
scale. If the \code{tr} argument to \code{choose.trans} is a character
constant, the appropriate named list of two functions will be generated.
Possibilities are: "exp", "log", "logit", "pctlogit" (transforms percentages
by the logit), "sqrt", "sq" (square), "cll" (complementary log-minus-log),
"ll" (log-minus-log).  If there is no match \code{NULL} is returned, which
will correspond to no transformation.
}
\description{
Choose a function and inverse based on a text string
}
\examples{

choose.trans( "logit" )

}
\author{
Bendix Carstensen, Steno Diabetes Center,
\url{http://bendixcarstensen.com/}.
}
