% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique_subformula_masses.R
\name{unique_subformula_masses}
\alias{unique_subformula_masses}
\title{unique_subformula_masses}
\usage{
unique_subformula_masses(fml, names = TRUE, check_validity = FALSE)
}
\arguments{
\item{fml}{Chemical formula.}

\item{names}{Return respective sub formulas as vector names.}

\item{check_validity}{Filter for chemically valid formulas.}
}
\value{
Numeric vector.
}
\description{
\code{unique_subformula_masses} will generate a numeric vector of
  potential sub formula masses regarding a chemical formula as input.
}
\details{
tbd.
}
\examples{
# specify a formula and calculate all potential combinatorial masses
fml <- c("C6H12O6", "C11H16NO4PS", "C24H51O4P")[1]
tmp <- unique_subformula_masses(fml = fml)
length(tmp); any(duplicated(tmp))
hist(tmp, breaks=seq(floor(min(tmp))-1, ceiling(max(tmp))), main=fml)
# do the same as above but check for chemical plausibility
tmp2 <- unique_subformula_masses(fml = fml, check_validity=TRUE)
length(tmp2)
hist(tmp2, breaks=seq(floor(min(tmp2))-1, ceiling(max(tmp2))), main=fml)
mz <- 147
tmp[abs(tmp-mz)<0.5]
tmp2[abs(tmp2-mz)<0.5]
}
