% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{r_to_d}
\alias{r_to_d}
\title{Convert Pearson's r to Cohen's d}
\usage{
r_to_d(r, sx, delta, N = NA, Ns = N, sx.known = FALSE)
}
\arguments{
\item{r}{Pearson's correlation}

\item{sx}{Sample standard deviation of X}

\item{delta}{Contrast in X for which to compute Cohen's d, specified in raw units of X (not standard deviations).}

\item{N}{Sample size used to estimate \code{r}}

\item{Ns}{Sample size used to estimate \code{sx}, if different from \code{N}}

\item{sx.known}{Is \code{sx} known rather than estimated? (By default, assumes \code{sx} is estimated, which will almost always be the case.)}
}
\description{
Converts Pearson's r (computed with a continuous X and Y) to Cohen's d
for use in meta-analysis. The resulting Cohen's d represents the
estimated increase in standardized Y that is associated with a delta-unit
increase in X.
}
\details{
To preserve the sign of the effect size, the code takes the absolute value of \code{delta}. The standard error
estimate assumes that X is approximately normal and that \code{N} is large.
}
\examples{
# d for a 1-unit vs. a 2-unit increase in X
r_to_d( r = 0.5,
        sx = 2,
        delta = 1,
        N = 100 )
r_to_d( r = 0.5,
        sx = 2,
        delta = 2,
        N = 100 )

# d when sx is estimated in the same vs. a smaller sample
# point estimate will be the same, but inference will be a little
# less precise in second case
r_to_d( r = -0.3,
         sx = 2,
         delta = 2,
         N = 300,
         Ns = 300 )

r_to_d( r = -0.3,
        sx = 2,
        delta = 2,
        N = 300,
        Ns = 30 )
}
\references{
1. Mathur MB & VanderWeele TJ (2019). A simple, interpretable conversion from Pearson's correlation to Cohen's d for meta-analysis. Epidemiology.
}
