% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{c_net_cal}
\alias{c_net_cal}
\title{Calculate spearman correlation for one or two t(otutab)}
\usage{
c_net_cal(
  totu,
  totu2 = NULL,
  method = "spearman",
  filename = FALSE,
  p.adjust.method = NULL,
  p.adjust.mode = "all",
  threads = 1,
  verbose = TRUE
)
}
\arguments{
\item{totu}{t(otutab)}

\item{totu2}{t(otutab2) or NULL}

\item{method}{spearman, pearson, sparcc,}

\item{filename}{the prefix of saved .corr file or FALSE}

\item{p.adjust.method}{see \code{\link[stats]{p.adjust}}}

\item{p.adjust.mode}{see \code{\link{p.adjust.table}}}

\item{threads}{threads, default: 1.}

\item{verbose}{verbose}
}
\value{
a corr list with 3 elements:
\item{r}{default: spearman correlation}
\item{p.value}{default: p-value of spearman correlation}
\item{p.adjust}{default p.adjust.method = NULL}
}
\description{
Calculate spearman correlation for one or two t(otutab)
}
\examples{
data("otutab", package = "pcutils")
t(otutab) -> totu
c_net_cal(totu) -> corr
metadata[, 3:10] -> env
c_net_cal(totu, env) -> corr2
}
