% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metalonda.R
\name{metalonda}
\alias{metalonda}
\title{Metagenomic Longitudinal Differential Abundant Analysis for one feature}
\usage{
metalonda(Count, Time, Group, ID, n.perm = 10, log = FALSE,
  fit.method = "nbinomial", points, text = 0, parall = FALSE,
  pvalue_threshold = 0.05, adjust.method = "BH")
}
\arguments{
\item{Count}{Count of feature for all groups for all time points for all samples.}

\item{Time}{Time label of all samples.}

\item{Group}{Group label of all samples.}

\item{ID}{individual ID label for samples.}

\item{n.perm}{number of permutations.}

\item{log}{log transformation of the data.}

\item{fit.method}{The fitting method (NB, LOWESS).}

\item{points}{The points at which the prediction should happen.}

\item{text}{Feature's name.}

\item{parall}{Logic to indicate whether to use multicore.}

\item{pvalue_threshold}{p_value threshold cutoff.}

\item{adjust.method}{multiple testing correction methods.}
}
\value{
Returns a list of the significant time intervals for the tested feature.
}
\description{
Find significant time interval of the tested feature
}
\examples{
data(metalonda_test_data)
n.sample = 5 # sample size;
n.timepoints = 10 # time point;
n.group= 2 # number of group;
Group = factor(c(rep(0,n.sample*n.timepoints), rep(1,n.sample*n.timepoints)))
Time = rep(rep(1:n.timepoints, times = n.sample), 2)
ID = factor(rep(1:(2*n.sample), each = n.timepoints))
points = seq(1, 10, length.out = 10)
output_1_nbinomial = metalonda(Count = metalonda_test_data[1,], Time = Time, Group = Group,
ID = ID, log = log, fit.method =  "nbinomial", n.perm = 10, points = points,
text=rownames(metalonda_test_data)[1], parall = FALSE, pvalue_threshold=0.05, adjust.method="BH")
}
\references{
Ahmed Metwally (ametwa2@uic.edu)
}
