% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeFilterResults.R
\name{summarizeFilterResults}
\alias{summarizeFilterResults}
\title{Summarize the filtered analysis results}
\usage{
summarizeFilterResults(metaObject, metaFilterLabel)
}
\arguments{
\item{metaObject}{the metaObject that contains the \code{filterObject} of interest}

\item{metaFilterLabel}{the name of a \code{filterObject} generated with the function \code{filterGenes()}}
}
\value{
Data frame, which contains \code{$pooledResults} information for each gene which passed the filter
}
\description{
Given a  \code{metaObject} and the name of the \code{filterObject} of interest, this function will print a summary style message about genes that passed the filtering step using the function \code{filterGenes()} and return a \code{dataFrame} that contains the \code{$pooledResults} information for each gene which passed the filter.
}
\examples{
# filter genes with default settings 
#		false discovery rate cutoff of 5 percent and WITH leave-one-out analysis
testMetaObject <- filterGenes(tinyMetaObject)
summarizeFilterResults(testMetaObject, getMostRecentFilter(testMetaObject))
}
\seealso{
\code{\link{filterGenes}}
}
\author{
Francesco Vallania
}
\keyword{methods}
\keyword{utilities}
