% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapPlot.R
\name{heatmapPlot}
\alias{heatmapPlot}
\title{Generates a heatmap with effect sizes for all genes which pass a filter in all measured diseases}
\usage{
heatmapPlot(metaObject, filterObject, colorRange = c(-1, 1))
}
\arguments{
\item{metaObject}{a Meta object which must have the $originalData, $metaAnalysis populated}

\item{filterObject}{a MetaFilter object containing the signature genes that will be used for the heatmap}

\item{colorRange}{a vector of length two with the minimum and maximum values for the heatmap colors. (default: c(-1,1))}
}
\value{
Generates a heatmap with effect sizes for all genes which pass a filter
}
\description{
Generates a heatmap with effect sizes for all genes which pass a filter in all measured diseases
}
\examples{
heatmapPlot(tinyMetaObject, tinyMetaObject$filterResults[[1]])
}
\author{
Winston A. Haynes
}

