% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_search.R
\name{searchRev}
\alias{searchRev}
\title{Reverse searching}
\usage{
searchRev(structure, ext.dbname = "extended", outfolder)
}
\arguments{
\item{structure}{SMILES structure string}

\item{ext.dbname}{Name of extended database (without .db), Default: 'extended'}

\item{outfolder}{Which folder are your databases in?}
}
\value{
Data table with m/z values, additionally molecular formula, charge, adduct, isotope %.
}
\description{
Takes a SMILES structure and finds m/z values for all adducts and isotopes matching that structure.
}
\examples{
 \dontrun{myFolder = tempdir()}
 \dontrun{buildBaseDB(outfolder = myFolder, "lmdb", test = TRUE)}
 \dontrun{file.remove(file.path(myFolder, "extended.db"))}
 \dontrun{data(adducts)}
 \dontrun{data(adduct_rules)}
 \dontrun{buildExtDB(outfolder = myFolder, base.dbname = "lmdb",
 silent=FALSE, adduct_table = adducts, adduct_rules = adduct_rules)}
 \dontrun{searchRev("O=C(O)C(N)CC=1N=CN(C1)C", outfolder = myFolder)}
}
\seealso{
\code{\link[RSQLite]{SQLite}}
}
