% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStats.R
\name{summaryStats}
\alias{summaryStats}
\title{Calculate summary statistics for evaluation measures}
\usage{
summaryStats(i, evalMeasuresDF, emNames, modelNames)
}
\arguments{
\item{i}{An integer representing 1:N where N is the total number of cross-validation rounds.}

\item{evalMeasuresDF}{A dataframe with the following columns: Model, RepNum, PosClass.FScore, PosClass.Recall, PosClass.Precision,
NegClass.FScore, NegClass.Recall, NegClass.Precision, and Accuracy. The rows of the dataframe will correspond to the results of
a particular model and a particular round of cross-validation.}

\item{emNames}{A list of names of the evaluation measures to visualize. Accepts the following: PosClass.FScore, PosClass.Recall,
PosClass.Precision, NegClass.FScore, NegClass.Recall, NegClass.Precision, and Accuracy. Default is "All".}

\item{modelNames}{A list of the models trained.}
}
\value{
A dataframe with the following columns: Model, evalMeasure, Mean, and SE (Standard Error).
}
\description{
For repeated cross-validation, find the mean and standard error of N rounds for each model.
}
\examples{
\donttest{summaryStatsList <-  lapply(1:numModels, summaryStats,
evalMeasuresDF=evalMeasuresDF, emNames=emNames, modelNames=modelNames)}

}
