% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetAlyzer_handler.R
\name{log2FC}
\alias{log2FC}
\title{Get log2FC Data}
\usage{
log2FC(metalyzer_se)
}
\arguments{
\item{metalyzer_se}{SummarizedExperiment}
}
\description{
This function returns the tibble "log2FC".
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)

metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = TRUE
)

log2FC(metalyzer_se)
}
