\name{get_mesh_ui_pair}
\alias{get_mesh_ui_pair}
\title{Union and intersection for a single pair of 3D meshes}
\description{Calculates the union and intersection of a single pair of 3D mesh objects.}
\usage{
get_mesh_ui_pair(x, boov=FALSE)
}
\arguments{
  \item{x}{\code{list} of two mesh objects as generated by \code{\link[MeshAgreement]{get_mesh_pairs}}.}
  \item{boov}{\code{logical}. Use package \code{\link[Boov]{MeshesUnion}} / \code{\link[Boov]{MeshesIntersection}} instead of the corresponding \code{\link[cgalMeshes]{cgalMesh}} methods for calculating union/intersection volumes. Depending on the meshes, this may have better performance.}
}
\details{Front-end for the \code{union} / \code{intersection} methods of the \code{\link[cgalMeshes]{cgalMesh}} class. Both are based on the CGAL library for computational geometry. Use \code{\link[MeshAgreement]{get_mesh_ui}} to get the respective union and intersection for all pairs from a list of 3D meshes. For \code{boov=TRUE}, packages \code{PolygonSoup} and \code{Boov} have to be installed separately.}
\value{\code{list} of two \code{\link[cgalMeshes]{cgalMesh}} objects for the union and intersection as well as the name of the comparison and a name for the structure.}
\references{\url{https://www.cgal.org/}}
\seealso{
\code{\link[MeshAgreement]{get_mesh_pairs}},
\code{\link[MeshAgreement]{get_mesh_ui}},
\code{\link[MeshAgreement]{get_mesh_agree_pair}},
\code{\link[cgalMeshes]{cgalMesh}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
pairL  <- get_mesh_pairs(heartL)
## check whether package Boov is available
have_boov <- requireNamespace("Boov", quietly=TRUE, partial=TRUE)
ui <- get_mesh_ui_pair(pairL[[1]], boov=have_boov)

## volume of union/intersection
ui$vol_u
ui$vol_i
}
