\name{get_mesh_metro_pair}
\alias{get_mesh_metro_pair}
\title{Distances between two 3D meshes}
\description{Calculate distances between two 3D meshes. Used for distance-based agreement measures such as the Hausdorff distance or the average surface distance.}
\usage{get_mesh_metro_pair(x, chop=TRUE, ...)}
\arguments{
  \item{x}{\code{list} of two 3D meshes that should be compared, e.g., a single component of the list generated by \code{\link[MeshAgreement]{get_mesh_pairs}}.}
  \item{chop}{\code{logical}. Delete the components from output of \code{\link[Rvcg]{vcgMetro}} that will not be used later on.}
  \item{...}{Options passed to \code{\link[Rvcg]{vcgMetro}}.}
}
\details{Thin front-end for \code{\link[Rvcg]{vcgMetro}}. Use \code{\link[MeshAgreement]{get_mesh_metro}} to process all pairs from a list of 3D meshes. Post-processing for agreement measures is done in \code{\link[MeshAgreement]{get_mesh_agree_pair}}.}
\value{\code{list} with object returned by \code{\link[Rvcg]{vcgMetro}} together with the name of the comparison and a name for the structure.}
\references{\url{http://vcg.isti.cnr.it/vcglib/}}
\seealso{
\code{\link[MeshAgreement]{get_mesh_pairs}},
\code{\link[MeshAgreement]{get_mesh_metro}},
\code{\link[MeshAgreement]{get_mesh_agree_pair}},
\code{\link[Rvcg]{vcgMetro}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
pairL  <- get_mesh_pairs(heartL)
metro  <- get_mesh_metro_pair(pairL[[1]], nSamples=500L, silent=TRUE)
# Hausdorff distance
get_HD_max <- function(x) {
    max(c(x$ForwardSampling$maxdist,
          x$BackwardSampling$maxdist))
}

get_HD_max(metro)
}
