% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_ivw-methods.R
\name{r.weights.delta}
\alias{r.weights.delta}
\title{Calculates p-values for penalization of weights with second-order weights}
\usage{
r.weights.delta(.Bx, .Bxse, .By, .Byse, .psi, .pen.weights)
}
\arguments{
\item{.Bx}{Beta-coefficient for genetic association with the risk factor.}

\item{.Bxse}{Standard error of genetic association with the risk factor.}

\item{.By}{Beta-coefficient for genetic association with the outcome.}

\item{.Byse}{Standard error of genetic association with the outcome.}

\item{.psi}{The correlation between the genetic associations with the exposure and the association with the outcome for each variant resulting from sample overlap.}

\item{.pen.weights}{Factors for penalizing weights.}
}
\value{
Penalized weights.
}
\description{
Internal function for calculating penalized weights in conjunction with \code{penalised.weights} with \code{weights} equal to \code{"delta"}.

These weights are used in either the \code{mr_ivw} or \code{mr_egger} functions when \code{penalized = TRUE}.
}
\details{
None.
}
\examples{
r.weights.delta(ldlc, ldlcse, chdlodds, chdloddsse, 0,
  penalised.weights.delta(ldlc, ldlcse, chdlodds, chdloddsse, 0))

}
\keyword{internal}

